
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class EvaluationSheet_Class : PI.FM.N000.Base.BL.DBD.BaseTable<BO.EvaluationSheet_Class>
    {
        #region Static factory
        private static EvaluationSheet_Class _factory = null;

        public static EvaluationSheet_Class DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new EvaluationSheet_Class();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_EvaluationSheet_Class";
        }

        protected override void InitializeProperties()
        {

            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("ClassID", "ClassID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("EvaluationSheetID", "EvaluationSheetID"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("From", "From"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("To", "To"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch       = 10,
            RemoveBySearch = 11
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch      : return new Command_RestoreBySearch();
                case (int)Commands.RemoveBySearch       : return new Command_RemoveBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.EvaluationSheet_Class>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.EvaluationSheet_Class.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("ClassID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("EvaluationSheetID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_EvaluationSheet_Class_RestoreBySearch";
            }
        }

        class Command_RemoveBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.EvaluationSheet_Class>
        {
            public Command_RemoveBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.EvaluationSheet_Class.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("ClassID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("EvaluationSheetID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("EditDate", Gemini.Core.BL.DAL.SqlTypes.DateTime));
                Add(new Gemini.Core.BL.DBD.Param("EditUser", Gemini.Core.BL.DAL.SqlTypes.BigInt));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_EvaluationSheet_Class_RemoveBySearch";
            }
        }
        #endregion
    }
}